<?php
/*--------------------------------------------------------------------
 OnGetSellingUnitWeightEventListener.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitWeight\Database\Listener;

use Gambio\Shop\Attributes\SellingUnitWeight\Database\Service\ReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitWeightEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Weight;

/**
 * Class OnGetSellingUnitWeightEventListener
 * @package Gambio\Shop\Attributes\SellingUnitWeight\Database\Listener
 */
class OnGetSellingUnitWeightEventListener
{
    /**
     * @var ReadServiceInterface
     */
    protected $service;
    
    
    /**
     * OnGetSellingUnitWeightEventListener constructor.
     *
     * @param ReadServiceInterface $service
     */
    public function __construct(ReadServiceInterface $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @param OnGetSellingUnitWeightEventInterface $event
     */
    public function __invoke(OnGetSellingUnitWeightEventInterface $event)
    {
        $attributeWeightDtos = $this->service->attributeWeights($event->modifiers());
        
        if (count($attributeWeightDtos)) {
            
            $weight = $event->weight()->value();
    
            foreach ($attributeWeightDtos as $dto) {
                
                if ($dto->weightPrefix() === '+') {
                    
                    $weight += $dto->weight();
                } else {
                    
                    $weight -= $dto->weight();
                }
            }
            
            $event->setWeight(new Weight($weight, $event->product()->showWeight()));
        }
    }
}